﻿using System;
using System.Collections;
using System.Web.UI;
using Soneta.Kadry;
using Soneta.Business;
using Soneta.Types;
using Soneta.Tools;
using Soneta.Kasa;
using Soneta.Web.Business.App;
using Soneta.Web.Business.Kadry;
using System.Collections.Generic;

namespace ASP {

    public partial class Pracownicy_Staz_Pracy : System.Web.UI.Page {

        public string Str_OkresAll = "(wszystko)";

        Date data;
        OkresContext okresContext;
	    DefPodstawyStazu zatrudnienie;
	    DefPodstawyStazu wykształcenie;

        protected void dc_ContextLoad(Object sender, EventArgs e) {
            okresContext = ((OkresContext)dc[typeof(OkresContext)]);
            data = okresContext.Aktualny;

		    // Odczytanie listy pracowników podległych z kontekstu
		    Row[] rows = getRows();

            ReportHeader["OKRES"] = (okresContext.Okres != FromTo.All) ? okresContext.Okres.ToString() : Str_OkresAll;
		    ReportHeader["AKTUALNY"] = data.ToString("yyyy-MM-dd");
		
		    KadryModule kadry = KadryModule.GetInstance(dc);
		    zatrudnienie = kadry.DefPodstawStazu.Zatrudnienie;
		    wykształcenie = kadry.DefPodstawStazu.Wyksztalcenie;

		    Grid.DataSource = rows;
	    }

        protected void Grid_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
            Pracownik pracownik = (Pracownik)args.Row;
        
            StazPracy firma = pracownik.StażPracy(data);
            StazPracy poza = pracownik.StażPracy(Date.Empty, zatrudnienie);
            StazPracy nauka = pracownik.StażPracy(Date.Empty, wykształcenie);
        
            StazPracy praca = (firma + poza).Normalizuj();
            StazPracy razem = (praca + nauka).Normalizuj();
        
            colFirma.EditValue = firma;
            colPoza.EditValue = poza;
            colNauka.EditValue = nauka;
            colPraca.EditValue = praca;
            colRazem.EditValue = razem;
            colOkres.EditValue = pracownik[okresContext.Aktualny].Etat.OkresZatrudnienia.From;
        }

	    private Row[] getRows() {
            IWebUser wu = dc.Context.Login.WebUserOperatingInstance;
            if (wu == null)
                return (Row[])dc[typeof(Row[])];

            List<Pracownik> list = new List<Pracownik>();
            Pracownik[] result = null;

            PodwladniKalkulator kalkPodwladni = new PodwladniKalkulator(dc.Context, wu.Host.ID);

            KadryModule module = KadryModule.GetInstance(dc);
            Soneta.Business.View view = module.Pracownicy.WgNazwiska.CreateView();
            // Warunek dla Etat
            RowCondition rcEtat = kalkPodwladni.FiltrEtatu(okresContext.Okres, null);
            // Pracownicy, Pracownicy młodociani (etat, umowa)
            view.Condition &= rcEtat;
            // Warunek dla Niezatrudnionych
            kalkPodwladni.UwzgledniajNiezatrudnionych = false;
            // Uwzględnij podwładnych
            IWebUser wo = dc.Context.Login.WebUserInstance;
            view.Condition &= kalkPodwladni.PrzeliczFiltr(wu==wo);
            view.ForceAllRows();
            foreach (Pracownik prac in view)
                list.Add(prac);
            result = list.ToArray();

            return result;
        }
    }
}				
